#!/bin/bash

################################################################################
#   A working example of Dyn.RS update script
################################################################################
#
#   User settings
#
#   ****************
#   *** hostname ***
#   ****************
#
#   The name(s) of hostname(s) to be updated.
#
#   You can specify up to 5 hostnames in one request, separated with commas (,).
#   Hostnames have to be created in your web control panel before they can
#   be specified here.
#
#   For example, if your username is "johndoe", your primary hostname will be
#   "johndoe.dyn.rs". Let's say you have already created two additional host-
#   names in the control panel: "home.johndoe.dyn.rs" and "work.johndoe.dyn.rs".
#
#   Beside specifying the full hostnames, you can also use only 4th level names.
#   If you'd like to update your default hostname "johndoe.dyn.rs", which is
#   a most common case, you could also specify an empty string or just "-" as a
#   hostname. Example:
#
#        hostname=johndoe.dyn.rs
#     or hostname="-"
#     or hostname=
#
#   To update all three hostnames with the same IP at once, you can specify the
#   hostnames in one of the following ways:
#
#        hostname=johndoe.dyn.rs,home.johndoe.dyn.rs,work.johndoe.dyn.rs
#     or hostname=,home,work
#
#   Notice the comma at the beginning, which delimits an empty string for your
#   primary hostname.
#
#   If you have a linux router and use your CPE in bridge mode, we suggest you
#   run this script only when bringing up your ppp interface, by calling it from
#   the file /etc/ppp/ip-up.local .
#
################################################################################

# Your DDNS username
username="YOUR_USERNAME"

# Your DDNS password
password="YOUR_PASSWORD"

# Hostname ("-" for primary hostname, "name" or "name.username.dyn.rs" for 4th level hostnames)
hostname="-"

################################################################################
# No changes needed below this line
################################################################################

if [[ ! -x "`which curl 2>/dev/null`" ]]
then
	echo
	echo "Could not find curl on your system."
	echo "Please install curl and try again.";
	echo
	exit 1;
fi

check_url="https://dyn.rs/checkip?format=text"
update_url="https://dyn.rs/v3/update"
ipfile=$(pwd)/_ip.txt

curip=$(curl -ks -A 'Dyn.rs - UpdateScript - v3.0' ${check_url})
update_req="?hostname=${hostname}&myip=${curip}"

[[ -f ${ipfile} ]] && oldip=$(cat ${ipfile}) || oldip="0"
if [[ ${oldip} != ${curip} ]]
then
	echo ${curip} > ${ipfile}
	res=$(curl -ks --basic -u ${username}:${password} -A 'Dyn.rs - UpdateScript - v3.0' ${update_url}${update_req})
	if [[ ! ${res} =~ ^SUCCESS && ! ${res} =~ ^good ]]
	then
		echo ${res}
		exit 1
	fi
fi
